***********************************************************************
*** Figure F2: Leave-one-out estimation ***
***********************************************************************
clear all 
use "$dataPath\Data"
do "$codePath\Transforming_variables"

regress global_credit_gap pcredit_gdp_gap
predict interak1, res

regress global_hp_gap hp_inc_gap
predict interak2, res

replace global_credit_gap = interak1
replace global_hp_gap = interak2

* Panel a)
preserve
set more off
forvalues i = 1(1)20 {
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap  gdp_gap i.country_id if country_id != `i' , robust cluster(period)
margins, dydx(dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap gdp_gap) post
coefplot, drop(_cons *country_id) generate(M`i')
}
keep M*
keep *b
br
*Saved as xls file to construct figure in appendix
cd "$outputPath"
export excel M* using model1.xls, replace
restore



* Panel b)
preserve
set more off
forvalues i = 1(1)20 {
logit crisis4_12 dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap  gdp_gap global_credit_gap global_hp_gap i.country_id if country_id != `i' , robust cluster(period)
margins, dydx(dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap  gdp_gap global_credit_gap global_hp_gap) post
coefplot, drop(_cons *country_id) generate(M`i')
}
keep M*
keep *b
br
*Saved as xls file to construct figure in appendix
cd "$outputPath"
export excel M* using model2.xls, replace
restore

* Panel c)
preserve
set more off
forvalues j = 1(1)20 {
logit crisis4_12  dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap  gdp_gap global_credit_gap global_hp_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu i.country_id if country_id != `j' , robust cluster(period)
margins, dydx(dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap  gdp_gap global_credit_gap global_hp_gap 1.ind_hp_inc_exu 1.ind_credit_gdp_exu) post
coefplot, drop(_cons *country_id) generate(M`j')
}
keep M*
keep *b
br
*Saved as xls file to construct figure in appendix
cd "$outputPath"
export excel M* using model3.xls, replace
restore

* Panel d)
preserve
set more off
forvalues j = 1(1)20 {
logit crisis4_12  dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap  gdp_gap global_credit_gap global_hp_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu wholesale_gap equity_assets i.country_id if country_id != `j' , robust cluster(period)
margins, dydx(dlogreal_pcredit hcredit_gdp_gap nfecredit_gdp_gap hp_inc_gap  gdp_gap global_credit_gap global_hp_gap 1.ind_hp_inc_exu 1.ind_credit_gdp_exu wholesale_gap equity_assets ) post
coefplot, drop(_cons *country_id) generate(M`j')
}
keep M*
keep *b
br
*Saved as xls file to construct figure in appendix
cd "$outputPath"
export excel M* using model4.xls, replace
restore
